const cards = document.querySelectorAll('.card');
const panel = document.getElementById('infoPanel');
const closeBtn = document.getElementById('closePanel');
const overlay = document.getElementById('overlay');
const panelTitle = document.getElementById('panelTitle');
const panelDescription = document.getElementById('panelDescription');
const panelImage = document.getElementById('panelImage');

function openPanel(card) {
  panelTitle.textContent = card.dataset.title;
  panelDescription.innerHTML = card.dataset.description;
  panelImage.src = card.dataset.image;

  panel.classList.add('open');
  overlay.classList.add('active');
}

function closePanel() {
  panel.classList.remove('open');
  overlay.classList.remove('active');
}

cards.forEach(card => {
  card.addEventListener('click', () => openPanel(card));
});

closeBtn.addEventListener('click', closePanel);
overlay.addEventListener('click', closePanel);


const panelLinks = document.getElementById('panelLinks');

function openPanel(card) {
  panelTitle.textContent = card.dataset.title;

  panelImage.src = card.dataset.image;

  panelDescription.innerHTML = card.dataset.description;

  panelLinks.innerHTML = card.dataset.links;

  panelImage.src = card.dataset.image;

  panel.classList.add('open');
  overlay.classList.add('active');
}

document.getElementById('year').textContent = new Date().getFullYear();

